/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: IOAccessDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 28.03.07 11:55 $
    $Revision: 896 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Device I/O Access Dialog class
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file IOAccessDlg.h
///   Device I/O Access Dialog class
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

#define WM_UPDATE_COUNTERS      (WM_USER + 1)
#define WM_UPDATE_SEND          (WM_USER + 2)
#define WM_UPDATE_RECV          (WM_USER + 3)

///////////////////////////////////////////////////////////////////////////////////////////
/// Device I/O Access Dialog class
///////////////////////////////////////////////////////////////////////////////////////////
class CIOAccessDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CIOAccessDlg)

public:
	CIOAccessDlg(CWnd* pParent = NULL);   // standard constructor
  virtual ~CIOAccessDlg();

// Dialog Data
	enum { IDD = IDD_IO_ACCESS };

  virtual void    OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  unsigned long   m_ulRecvArea;     //!< Area index of Input Image
  unsigned long   m_ulRecvOffset;   //!< Offset in Input Image
  unsigned long   m_ulRecvSize;     //!< Data size to fetch from Input Image
  unsigned char*  m_pabRecvBuffer;  //!< Buffer containing latest fetched IO Image

  unsigned long   m_ulSendArea;     //!< Area index of Output Image
  unsigned long   m_ulSendOffset;   //!< Offset in Output Image
  unsigned long   m_ulSendSize;     //!< Data size to put into Ouput Image
  unsigned char*  m_pabSendBuffer;  //!< Buffer containing Output Image

  CComboBox       m_cUpdateRateCtrl;//!< Update rates Combobox control
  CButton         m_cCyclicSendCtrl;//!< Cyclic send checkbox control
  CButton         m_cAutoIncrementCtrl; //!< Auto increment data checkbox control

  CComboBox       m_cInputAreaCtrl; //!< Input Area selection Combobox control
  CComboBox       m_cOutputAreaCtrl;//!< Output Area selection Combobox control

  CEdit           m_cOutputDataCtrl;//!< Output data edit control
  CEdit           m_cInputDataCtrl; //!< Input data edit control
  
  CFont           m_cFixedFont;

  CEdit           m_cInputDataLenCtrl;    //!< Input data length edit control
  CEdit           m_cInputDataOffsetCtrl; //!< Input data offset edit control

  CEdit           m_cOutputDataLenCtrl;   //!< Output data length edit control
  CEdit           m_cOutputDataOffsetCtrl;//!< Output data offset edit control

  long            m_lLastReadResult;      //!< Last error from xChannelReadIo
  long            m_lLastWriteResult;     //!< Last error from xChannelWriteIo

  bool            m_fCyclicOutput;        //!< true if cyclic output is to be scheduled
  bool            m_fAutoIncrementData;   //!< true if the output data is to be incremented automatically
  bool            m_fDeviceValid;         //!< true if a valid device is open, and IO Data exchange is to be done
  bool            m_fVerifyOutputs;       //!< true will verify if the outputs were correctly 
  bool            m_fSendUpdateActive;    //!< true if Output data is currently being drawn to screen
  bool            m_fRecvUpdateActive;    //!< true if Input data is currently being drawn to screen

  unsigned char   m_abCompareBuffer[0x10000]; //!< Buffer for comparing output data

  CRITICAL_SECTION m_tcsLengthChange;     //!< Critical section to allow safe realloc of send/receive buffers

	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();

  virtual void ThreadFunction(void);
  afx_msg void OnEnKillfocusRecvOffset();
  afx_msg void OnEnKillfocusRecvLength();
  afx_msg void OnEnKillfocusSendOffset();
  afx_msg void OnEnKillfocusSendLength();

  LRESULT UpdateRecvData(WPARAM wParam = 0, LPARAM lParam = 0);
  LRESULT UpdateSendData(WPARAM wParam = 0, LPARAM lParam = 0);
  afx_msg void OnBnClickedBtnUpdate();
  afx_msg void OnEnUpdateSendData();
  afx_msg void OnEnKillfocusSendData();
  afx_msg void OnCbnSelchangeComboUpdaterate();
  afx_msg void OnBnClickedChkCyclic();
  afx_msg void OnBnClickedChkAutoincr();
  
  bool ValidateSendData(void);
  afx_msg void OnBnClickedChkVerifyoutput();
  CButton m_cVerifyOutputsCtrl;
};
